﻿using System.Text.RegularExpressions;

namespace Marimo.開発支援.ソース生成ライブラリ
{
    /// <summary>
    /// フォーマットを使って定義されたソースコードを表すクラスの基底となります。
    /// </summary>
    public abstract class フォーマット定義されたソースコード : ソースコード
    {
        /// <summary>
        /// フォーマット定義されたソースコードのインスタンスを生成します。
        /// </summary>
        /// <param name="インデント数">親要素からのインデント。</param>
        protected フォーマット定義されたソースコード(int インデント数)
            : base(インデント数)
        {
        }

        /// <summary>
        /// コードのフォーマットを取得します。
        /// </summary>
        protected abstract string フォーマット { get; }

        /// <summary>
        /// 定義されたフォーマットに書式項目をあてはめ、インデントを考慮してソースを設定します。
        /// </summary>
        /// <param name="arg0">書式設定するSystem.Object。</param>
        protected void ソースを設定する(params object[] arg0)
        {
            //改行の間に、インデントを挿入してソースとして設定します。
            ソース = Regex.Replace(string.Format(フォーマット, arg0), @"(?<=\r\n)(?!\r)", インデント);
        }
    }
}